/*
 * Decompiled with CFR 0.152.
 */
package com.cgessinger.creaturesandbeasts.common.util;

import com.cgessinger.creaturesandbeasts.common.config.CNBConfig;
import com.cgessinger.creaturesandbeasts.common.entites.LizardEntity;
import com.cgessinger.creaturesandbeasts.common.init.ModItems;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ModEventHandler {
    @SubscribeEvent
    public static void onBlockActivate(PlayerInteractEvent.RightClickBlock event) {
        Item heldItem;
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te instanceof JukeboxTileEntity && (heldItem = event.getPlayer().func_184586_b(event.getHand()).func_77973_b()) instanceof MusicDiscItem) {
            List lizards = event.getWorld().func_217357_a(LizardEntity.class, event.getPlayer().func_174813_aQ().func_186662_g(15.0));
            for (LizardEntity lizard : lizards) {
                lizard.setPartying(true, event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.func_201670_d()) {
            return;
        }
        PlayerInventory inv = event.player.field_71071_by;
        Stream playerItems = Stream.concat(inv.field_70460_b.stream(), inv.field_70462_a.stream());
        Stream conatinerItems = Stream.empty();
        if (event.player.field_71070_bA != null) {
            conatinerItems = event.player.field_71070_bA.func_75138_a().stream();
        }
        Stream.concat(playerItems, conatinerItems).forEach(stack -> {
            if (stack.func_77973_b() instanceof ArmorItem) {
                ModEventHandler.checkAndUpdateItemArmor(stack);
            }
        });
    }

    private static void checkAndUpdateItemArmor(ItemStack input) {
        if (input.func_77942_o() && input.func_77978_p().func_74764_b("hide_amount")) {
            if (input.func_77978_p().func_150297_b("AttributeModifiers", 9)) {
                input.func_196083_e("AttributeModifiers");
            }
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                Multimap modOld = input.func_77973_b().getAttributeModifiers(slot, input);
                int hideAmount = input.func_77978_p().func_74762_e("hide_amount");
                for (Map.Entry entry : modOld.entries()) {
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    if (((Attribute)entry.getKey()).equals(Attributes.field_233826_i_)) {
                        modifier = new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() * Math.pow((Double)CNBConfig.ServerConfig.HIDE_MULTIPLIER.value, hideAmount), modifier.func_220375_c());
                    }
                    input.func_185129_a((Attribute)entry.getKey(), modifier, slot);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAnvilChange(AnvilUpdateEvent event) {
        if (event.getLeft().func_77973_b() instanceof ArmorItem && event.getRight().func_77973_b() == ModItems.YETI_HIDE.get()) {
            ItemStack output = event.getLeft().func_77946_l();
            CompoundNBT nbt = output.func_196082_o();
            int hideAmount = 1;
            if (nbt.func_74764_b("hide_amount") && (hideAmount += nbt.func_74762_e("hide_amount")) > (Integer)CNBConfig.ServerConfig.HIDE_AMOUNT.value) {
                return;
            }
            nbt.func_74768_a("hide_amount", hideAmount);
            event.setCost(((Integer)CNBConfig.ServerConfig.HIDE_COST.value).intValue());
            event.setMaterialCost(1);
            event.setOutput(output);
        }
    }
}

